FSR25_R10_Mexico
{
  Filter Properties = *
  Attrition = 30
  TrackName = Mexico FSR
  EventName = Round 10: Mexico
  VenueName = FSR 2025 - Mexico
  VenueIcon = MexicoIcon.dds
  Location = Ciudad de Mexico, MEX
  Length = 4.340 km
  HeadlightsRequired = false        // whether headlights are required at night
  TerrainDataFile = ..\Mexico.tdf
  
  GarageDepth = 2.5
  RacePitKPH = 80
  NormalPitKPH = 80
  Practice1Day = Friday
  Practice1Start = 12:00
  Practice1Duration = 120
  Practice2Day = Saturday
  Practice2Start = 14:00
  Practice2Duration = 15
  QualifyDay = Saturday
  QualifyStart = 13:00
  QualifyLaps = 99  
  QualifyDuration = 15
  WarmupDay = Sunday
  WarmupStart = 13:30
  WarmupDuration = 5
  RaceDay = Sunday
  RaceStart = 14:00
  RaceLaps = 71
  RaceTime = 120

  NumStartingLights=6

  RearFlapZoneSessions=31
  RearFlapWetThreshold=0.1

  RearFlapZone
  {
  MinimumCrossings=2
  TimeThreshold=1.0
  DetectionLapDist=3019.5
  ActivationLapDist=3317.2
  DeactivationLapDist=3731.5
  }
  RearFlapZone
  {
  MinimumCrossings=2
  TimeThreshold=1.0
  DetectionLapDist=4099.2
  ActivationLapDist=1571.1
  DeactivationLapDist=2111.2
  }
  RearFlapZone
  {
  MinimumCrossings=2
  TimeThreshold=1.0
  DetectionLapDist=4099.2
  ActivationLapDist=241.4
  DeactivationLapDist=1239.6
  }

  //Atmospherics
  AirPollution=0.35
  NightLightPollution=12.0
  HazeBaseScale=1.0
  HazeCloudyScale=1.0
  HazeStormScale=1.0
  HazeDawnScale=1.0

  ShadowMinSunAngle = 15.0
  NightLightThreshold = 0.5

  Latitude = 19.4059				// degs from Equator (range: -90 to 90, positive is Northern Hemisphere)
  Longitude = -99.0938				// degs from GMT (-180 to 180, positive is East)
  Altitude = 2236				// meters above sea level
  RaceDate = August 27, 2022  		// default date for the race
  TimezoneRelativeGMT = -5			// hours compared to Greenwich Mean Time (should be negative to the West)
//  DSTRange=(1.0, 1.0, 0, 9999) // (start day 1.0-367.0, end day 1.0-367.0, start year, end year); multiple lines allowed
//  U.S. example, where DST changed in 2007 (previous and future changes not simulated here):
//  DSTRange=(94.8, 301.3, 1987, 2006) // approximation of 1st Sunday in April to last Sunday in October
//  DSTRange=(70.8, 308.3, 2007, 9999) // approximation of 2nd Sunday in March to first Sunday in November

  // Cut track penalty threshold adjusters, to help tune, check score.cpp in a +trace=3 trace.txt file
  CutPitlaneLimits = 0 //Enable or disable cut detection when leaving the pits
  CutPitlaneLimitsPractice = 0 //Enable or disable cut detection when leaving the pits in practice sessions
  CutPitlaneLimitsQualifying = 0 //Enable or disable cut detection when leaving the pits in qualifying sessions
  CutPitlaneLimitsPrivate = 0 //Enable or disable cut detection when leaving the pits in private non race sessions
  CutPitlaneLimitsRace = 0 //Enable or disable cut detection when leaving the pits in race sessions
  CutLeavingScalar = 0.6 //How many car track widths outside the track boundary are cuts triggered (this is measured from the centre of the car)
  CutJoiningScalar = 0.0 //How many car track widths inside the track boundary is a cut finalized.
  CutNextLapInvalidDist = 4150.0 //Manually set the distance at which the next lap will be invalidated. This is auto calculated by default.
  CutNextLapThreshPractice = 50000.0 //The number of penalty points in a single infraction to invalidate the next lap in a practice session
  CutNextLapThreshQualifying = 50000.0 //The number of penalty points in a single infraction to invalidate the next lap in a qualifying session
  CutNextLapThreshRace = 50000.0 //The number of penalty points in a single infraction to invalidate the next lap in a race session

///////////////////////////LOOSE OBJECT DATA///////////////////////////
  CONE = ( 10.0, 80.0, 40.0, 120.0, 20480.0, 896.0, 2.8 )	// default ( 2.5, 0.25, 0.20, 0.25, 1425.6, 72.0, 0.80 )	( 10.0, 8.0, 4.0, 12.0, 2048.0, 89.6, 2.80 )
  POST = ( 2.4, 1.0, 0.2, 1.0, 800.0, 80.0, 1.60 )		// default ( 1.2, 0.5, 0.1, 0.5, 400.0, 40.0, 0.80 )
  SIGN = ( 1.2, 0.5, 0.1, 0.5, 400.0, 40.0, 0.80 )		// default inertia parameters for signs are actually calculated based on geometry ( 5.0, 4.0, 2.0, 6.0, 1024.                                                         

  SettingsFolder = FSR_Mexico
  SettingsCopy = FSR_Mexico.svm
  SettingsAI = FSR_Mexico.svm
}